IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[P_EST_NF_SAI_IT_COMIS_RECALC_HISTORICO]')
          AND type IN(N'P', N'PC')
)
    BEGIN
        DROP PROCEDURE [P_EST_NF_SAI_IT_COMIS_RECALC_HISTORICO]
    END;
GO



--EXEC P_EST_NF_SAI_IT_COMIS_RECALC 1,3,'','2016-11-01','2016-11-30'
CREATE PROCEDURE [P_EST_NF_SAI_IT_COMIS_RECALC_HISTORICO](@CD_EMP    INT          = 1,
                                                      @CD_FILIAL VARCHAR(200),
                                                      @CD_FUN    VARCHAR(MAX) = '',
                                                      @DT_INI    DATETIME     = NULL,
                                                      @DT_FIM    DATETIME     = NULL,
                                                      @CD_PROD   INT          = 0)
WITH RECOMPILE AS
    SET NOCOUNT ON;
    BEGIN TRY
        BEGIN
        DECLARE @CD_EMP_RS INT;
        DECLARE @CD_FILIAL_RS INT;
        DECLARE @CD_VD_RS INT;
        DECLARE @CD_IT_RS INT;
        DECLARE @CD_PROD_RS INT;
        DECLARE @CD_VEND INT;
        DECLARE @CD_VEND_RS INT;
        DECLARE @PERC_COMIS MONEY;
        DECLARE @DS_PERC_COMIS VARCHAR(100);
        DECLARE @VLR_COMISSAO_FABRIC MONEY;
        DECLARE @DS_VLR_COMIS VARCHAR(100);
         
	   CREATE TABLE #tmp_filial
				(cd_emp    INT,
				 cd_filial INT);

	   CREATE TABLE #tmp_vend(cd_fun INT);
            
	   INSERT INTO #tmp_filial
	   SELECT @CD_EMP
		  , ID
	   FROM UFD_PRM_IN_STRING(@CD_FILIAL);
            
 	   CREATE UNIQUE CLUSTERED INDEX #Ixd_tmp_filial ON #tmp_filial (CD_EMP,CD_FILIAL); 

	   INSERT INTO #tmp_vend
	   SELECT ID
	   FROM UFD_PRM_IN_STRING(@CD_FUN);


	   SELECT *
	   INTO #V_EST_PROD_TBL_COMIS_POSSUI
	   FROM V_EST_PROD_TBL_COMIS_POSSUI_HISTORICO

	   CREATE TABLE #VendasProcessar (CD_EMP INT,
							 CD_FILIAL INT,
							 CD_VD INT,
							 CD_IT INT,
							 CD_PROD INT,
							 CD_VEND INT,
							 DT_VD DATETIME)

            IF LTRIM(RTRIM(@CD_FUN)) <> ''
                BEGIN
				 

				INSERT INTO #VendasProcessar
				SELECT DISTINCT
					   a.CD_EMP
					   , a.CD_FILIAL
					   , a.CD_NF
					   , a.CD_IT
					   , a.CD_PROD
					   , S.CD_VEND
					   , a.DT_EMI_NF
				FROM
				    EST_NF_SAI_IT a JOIN EST_NF_SAI s ON 
				    a.cd_emp	    = s.cd_emp AND 
				    a.cd_nf	    = s.cd_nf AND 
				    a.cd_filial   = s.cd_filial AND 
				    a.dt_emi_nf   = s.dt_emi_nf
				    
				    INNER JOIN #tmp_vend v ON 
				    v.cd_fun = s.CD_VEND

				    INNER JOIN #V_EST_PROD_TBL_COMIS_POSSUI pc ON
				    A.CD_EMP	    = pc.CD_EMP AND 
				    A.CD_FILIAL   = pc.CD_FILIAL AND
				    A.CD_PROD	    = pc.CD_PROD  

				    INNER JOIN #tmp_filial L ON 
				    pc.CD_FILIAL   = L.CD_FILIAL AND
				    pc.CD_EMP	    = L.CD_EMP  

				WHERE 
				    pc.CD_EMP = 1
				    AND pc.TIPO_COMISSAO=0
				    AND a.CD_EMP=1
				    AND S.CD_VEND > 0
				    AND a.dt_emi_nf BETWEEN @DT_INI AND @DT_FIM
				    AND A.CD_PROD = CASE
										  WHEN @CD_PROD = 0
										  THEN A.CD_PROD
										  ELSE @CD_PROD
									   END;

                END;

            IF LTRIM(RTRIM(@CD_FUN)) = ''
                BEGIN
				INSERT INTO #VendasProcessar
				SELECT DISTINCT
					   a.CD_EMP
					   , a.CD_FILIAL
					   , a.CD_NF
					   , a.CD_IT
					   , a.CD_PROD
					   , S.CD_VEND
					   , a.DT_EMI_NF
				FROM
				    EST_NF_SAI_IT a JOIN EST_NF_SAI s ON 
				    a.cd_emp	    = s.cd_emp AND 
				    a.cd_nf	    = s.cd_nf AND 
				    a.cd_filial   = s.cd_filial AND 
				    a.dt_emi_nf   = s.dt_emi_nf
					 
				    INNER JOIN #V_EST_PROD_TBL_COMIS_POSSUI pc ON
				    A.CD_EMP	    = pc.CD_EMP AND 
				    A.CD_FILIAL   = pc.CD_FILIAL AND
				    A.CD_PROD	    = pc.CD_PROD  

				    INNER JOIN #tmp_filial L ON 
				    pc.CD_FILIAL   = L.CD_FILIAL AND
				    pc.CD_EMP	    = L.CD_EMP  

				WHERE 
				    pc.CD_EMP = 1
				    AND pc.TIPO_COMISSAO=0
				    AND a.CD_EMP=1
				    AND S.CD_VEND > 0
				    AND a.dt_emi_nf BETWEEN @DT_INI AND @DT_FIM
				    AND A.CD_PROD = CASE
										  WHEN @CD_PROD = 0
										  THEN A.CD_PROD
										  ELSE @CD_PROD
									   END;
            END;


			--Nome do cursor
			DECLARE CurItens CURSOR
			FOR
				-- Select utilizado para o cursor
				SELECT DISTINCT
						a.CD_EMP
						, a.CD_FILIAL
						, a.CD_VD
						, a.CD_IT
						, a.CD_PROD
						, a.CD_VEND
						, ISNULL(F.PERC_COMIS, 0)
						, ISNULL(F.DS_COMIS_PERC, 'NAO DEFINIDO')
						, ISNULL(F.VLR_COMIS, 0)
						, ISNULL(F.DS_COMIS_VLR, 'NAO DEFINIDO')
				FROM
						#VendasProcessar a
						OUTER APPLY UFD_EST_PROD_COMIS_HISTORICO(A.CD_EMP, a.CD_FILIAL, a.CD_PROD, A.CD_VEND, 0, a.DT_VD) F


            --Abrindo cursor
            OPEN CurItens;
  
            --Atribuindo valores do select nas variáveis
            FETCH NEXT FROM CurItens INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, @CD_IT_RS, @CD_PROD_RS, 
								    @CD_VEND_RS, @PERC_COMIS, @DS_PERC_COMIS, 
										  @VLR_COMISSAO_FABRIC, @DS_VLR_COMIS;


            --Iniciando laço
            WHILE @@FETCH_STATUS = 0
                BEGIN
                    PRINT 'Vendedor.: ' + CONVERT(VARCHAR(100), @CD_VEND_RS)
						  +' produto.: ' + CONVERT(VARCHAR(100), @CD_PROD_RS) 
						  + ' tipo comissao.:  ' + @DS_PERC_COMIS
						  +' descri. comissao.:  ' + @DS_VLR_COMIS;
                    UPDATE I
                      SET
                          I.PERC_COMI		   = @PERC_COMIS, 
                          I.DS_PERC_COMIS	   = @DS_PERC_COMIS,
                          I.VLR_COMISSAO_FABRIC = @VLR_COMISSAO_FABRIC,
                          I.DS_VLR_COMIS	   = @DS_VLR_COMIS
                    FROM 
				    EST_NF_SAI_IT I
				    JOIN EST_NF_SAI s ON 
					    I.cd_emp	 = s.cd_emp AND 
					    I.cd_nf	 = s.cd_nf AND 
					    I.cd_filial = s.cd_filial AND 
					    I.dt_emi_nf	 = s.dt_emi_nf 
                    WHERE 
				    I.CD_EMP = @CD_EMP_RS
				    AND I.CD_FILIAL = @CD_FILIAL_RS
				    AND I.CD_NF = @CD_VD_RS
				    AND S.CD_VEND = @CD_VEND_RS
				    AND I.CD_IT = @CD_IT_RS
				    AND (I.PERC_COMI <> @PERC_COMIS
					   OR I.VLR_COMISSAO_FABRIC <> @VLR_COMISSAO_FABRIC);

                    --Próxima linha do cursor
                    FETCH NEXT FROM CurItens INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, @CD_IT_RS, @CD_PROD_RS, 
										  @CD_VEND_RS, @PERC_COMIS, @DS_PERC_COMIS, @VLR_COMISSAO_FABRIC, @DS_VLR_COMIS;
                END;

            CLOSE CurItens;
            DEALLOCATE CurItens;  

            IF OBJECT_ID('TEMPDB.DBO.#tmp_vend') IS NOT NULL
                BEGIN
                    DROP TABLE #tmp_vend;
                END;
            IF OBJECT_ID('TEMPDB.DBO.#tmp_filial') IS NOT NULL
                BEGIN
                    DROP TABLE #tmp_filial;
                END; 

        END;
    END TRY
    BEGIN CATCH
 	 
	   DECLARE @mensagemErro	varchar(250);
	   DECLARE @severidadeErro int;
	   DECLARE @estadoErro		int;


	   SELECT	@mensagemErro	= 'Falha atualizacao' + ERROR_MESSAGE(), 
			@severidadeErro = ERROR_SEVERITY(), 
			@estadoErro		= ERROR_STATE();
	  
        INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
	   SELECT 
		    ERROR_NUMBER() AS numero
		  , @severidadeErro AS severidade
		  , @estadoErro AS estado
		  , ERROR_PROCEDURE() AS rotina
		  , ERROR_LINE() AS linha
		  , @mensagemErro AS mensagem
		  , GETDATE() AS dtErro;

	   RAISERROR (@mensagemErro, @severidadeErro, @estadoErro); 

    END CATCH;
GO


